VERSION 5.00
Begin VB.Form frmIRMARM 
   Caption         =   "ARM/IRM Controller"
   ClientHeight    =   3795
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   7245
   ControlBox      =   0   'False
   LinkTopic       =   "Form1"
   MDIChild        =   -1  'True
   ScaleHeight     =   3795
   ScaleWidth      =   7245
   Begin VB.Timer tmrARMWatch 
      Interval        =   10000
      Left            =   0
      Top             =   3360
   End
   Begin VB.Frame frameIRM 
      Caption         =   "IRM"
      Height          =   3135
      Left            =   2160
      TabIndex        =   4
      Top             =   120
      Width           =   2775
      Begin VB.CommandButton cmdInterruptCharge 
         Caption         =   "Interrupt"
         Height          =   375
         Left            =   1800
         TabIndex        =   35
         Top             =   1200
         Width           =   735
      End
      Begin VB.CommandButton cmdIRMAverageVoltageIn 
         Caption         =   "Read IRM Voltage:"
         Height          =   255
         Left            =   120
         TabIndex        =   34
         Top             =   2760
         Width           =   1695
      End
      Begin VB.TextBox txtIRMAverageVoltageIn 
         Height          =   288
         Left            =   2040
         TabIndex        =   33
         Top             =   2760
         Width           =   492
      End
      Begin VB.CheckBox chkBackfield 
         Caption         =   "Negative Polarity"
         Height          =   255
         Left            =   120
         TabIndex        =   17
         Top             =   2160
         Width           =   1815
      End
      Begin VB.CheckBox chkIRMLFCoil 
         Caption         =   "LF Coil"
         Height          =   195
         Left            =   120
         TabIndex        =   16
         Top             =   1440
         Width           =   1575
      End
      Begin VB.CheckBox chkIRMHFCoil 
         Caption         =   "HF Coil"
         Height          =   195
         Left            =   120
         TabIndex        =   15
         Top             =   1200
         Width           =   1575
      End
      Begin VB.CheckBox chkForceIRMCoil 
         Caption         =   "Lock coil selection"
         Height          =   255
         Left            =   120
         TabIndex        =   14
         Top             =   1680
         Width           =   1695
      End
      Begin VB.TextBox txtPulseField 
         Height          =   288
         Left            =   1200
         TabIndex        =   9
         Top             =   720
         Width           =   492
      End
      Begin VB.CommandButton cmdIRMFirebyGauss 
         Caption         =   "Fire"
         Height          =   372
         Left            =   1800
         TabIndex        =   8
         Top             =   720
         Width           =   732
      End
      Begin VB.CommandButton cmdIRMFire 
         Caption         =   "Fire"
         Height          =   372
         Left            =   1800
         TabIndex        =   7
         Top             =   240
         Width           =   732
      End
      Begin VB.TextBox txtPulseVolts 
         Height          =   288
         Left            =   1200
         TabIndex        =   5
         Top             =   240
         Width           =   492
      End
      Begin VB.Label lblIRMStatus 
         Alignment       =   2  'Center
         Height          =   255
         Left            =   120
         TabIndex        =   18
         Top             =   2520
         Width           =   2415
      End
      Begin VB.Label Label2 
         Caption         =   "Peak field (G):"
         Height          =   252
         Left            =   120
         TabIndex        =   10
         Top             =   720
         Width           =   1332
      End
      Begin VB.Label Label1 
         Caption         =   "Voltage:"
         Height          =   252
         Left            =   120
         TabIndex        =   6
         Top             =   240
         Width           =   1332
      End
   End
   Begin VB.Frame frameARM 
      Caption         =   "ARM"
      Height          =   3135
      Left            =   0
      TabIndex        =   3
      Top             =   120
      Width           =   2052
      Begin VB.TextBox txtBiasField 
         Height          =   288
         Left            =   1320
         TabIndex        =   12
         Top             =   480
         Width           =   492
      End
      Begin VB.CommandButton cmdSetBiasField 
         Caption         =   "Set"
         Height          =   372
         Left            =   360
         TabIndex        =   11
         Top             =   840
         Width           =   732
      End
      Begin VB.Label Label3 
         Caption         =   "Bias field (G):"
         Height          =   252
         Left            =   120
         TabIndex        =   13
         Top             =   480
         Width           =   1332
      End
   End
   Begin VB.Frame frameMCC 
      Caption         =   "MC Controller"
      Height          =   3135
      Left            =   5040
      TabIndex        =   1
      Top             =   120
      Width           =   2175
      Begin VB.TextBox txtMCCIRMReady 
         Height          =   288
         Left            =   1560
         TabIndex        =   32
         Top             =   2760
         Width           =   492
      End
      Begin VB.CommandButton cmdMCCIRMReady 
         Caption         =   "Read IRM Rdy:"
         Height          =   255
         Left            =   120
         TabIndex        =   31
         Top             =   2760
         Width           =   1335
      End
      Begin VB.TextBox txtMCCIRMTrim 
         Height          =   288
         Left            =   1560
         TabIndex        =   30
         Top             =   2400
         Width           =   492
      End
      Begin VB.CommandButton cmdMCCIRMTrim 
         Caption         =   "IRM Trim:"
         Height          =   255
         Left            =   120
         TabIndex        =   29
         Top             =   2400
         Width           =   975
      End
      Begin VB.TextBox txtMCCIRMFire 
         Height          =   288
         Left            =   1560
         TabIndex        =   28
         Top             =   2040
         Width           =   492
      End
      Begin VB.CommandButton cmdMCCIRMFire 
         Caption         =   "IRM Fire:"
         Height          =   255
         Left            =   120
         TabIndex        =   27
         Top             =   2040
         Width           =   975
      End
      Begin VB.TextBox txtMCCARMSet 
         Height          =   288
         Left            =   1560
         TabIndex        =   26
         Top             =   960
         Width           =   492
      End
      Begin VB.CommandButton cmdMCCARMSet 
         Caption         =   "ARM Set:"
         Height          =   255
         Left            =   120
         TabIndex        =   25
         Top             =   960
         Width           =   975
      End
      Begin VB.TextBox txtMCCIRMVin 
         Height          =   288
         Left            =   1560
         TabIndex        =   24
         Top             =   1680
         Width           =   492
      End
      Begin VB.CommandButton cmdMCCIRMVin 
         Caption         =   "Read IRM V in:"
         Height          =   255
         Left            =   120
         TabIndex        =   23
         Top             =   1680
         Width           =   1335
      End
      Begin VB.TextBox txtMCCIRMVout 
         Height          =   288
         Left            =   1560
         TabIndex        =   22
         Top             =   1320
         Width           =   492
      End
      Begin VB.TextBox txtMCCARMVout 
         Height          =   288
         Left            =   1560
         TabIndex        =   21
         Top             =   600
         Width           =   492
      End
      Begin VB.CommandButton cmdMCCIRMVout 
         Caption         =   "IRM V:"
         Height          =   255
         Left            =   120
         TabIndex        =   20
         Top             =   1320
         Width           =   735
      End
      Begin VB.CommandButton cmdMCCARMVout 
         Caption         =   "ARM V:"
         Height          =   255
         Left            =   120
         TabIndex        =   19
         Top             =   600
         Width           =   735
      End
      Begin VB.CommandButton cmdShowMCC 
         Caption         =   "Show"
         Height          =   255
         Left            =   960
         TabIndex        =   2
         Top             =   240
         Width           =   1095
      End
   End
   Begin VB.CommandButton cmdClose 
      Caption         =   "Close"
      Height          =   372
      Left            =   6000
      TabIndex        =   0
      Top             =   3360
      Width           =   1212
   End
End
Attribute VB_Name = "frmIRMARM"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' This is for handling directives to MCC
' for control of IRM/ARM
Option Explicit
' (March 2008 L Carporzen) Put in Settings the IRM/ARM channels (MIT acquisition board does not work on IRMTrim = 3
' Analog channel output
'Const ARMVoltageOut As Integer = 0
'Const IRMVoltageOut As Integer = 1
' Analog input
'Const IRMCapacitorVoltageIn As Integer = 0
' DIO line assignments
'Const ARMSet As Integer = 0
'Const IRMFire As Integer = 1
'Const IRMTrim As Integer = 7 '3 (August 2007 L Carporzen) Pin changed after Pin 3 fried on the acquisition box/card
'Const IRMReady As Integer = 4
Dim ARMStartTime As Date
Dim CurrentBiasField As Double
Dim IRMHFMode As Integer
Dim IRMBackfieldMode As Boolean
Dim AutosetIRMEnabled As Boolean
Dim IRMInterrupt As Boolean

Public Sub IRMInterruptCharge()
    IRMInterrupt = True
End Sub

Public Function IRMCenteringPos(Optional ByVal field As Double = 0) As Long
    If Abs(field) > PulseLFMax Then
        IRMCenteringPos = IRMHiPos
    Else
        IRMCenteringPos = IRMPos
    End If
End Function

Public Sub SetIRMHFMode(enabling As Integer)
    If Not EnableIRMHi Then enabling = 0
    If enabling = 1 Then
        IRMHFMode = 1
        chkIRMHFCoil.value = Checked
        chkIRMLFCoil.value = Unchecked
    ElseIf enabling = 2 Then
        IRMHFMode = 2
        chkIRMHFCoil.value = Checked
        chkIRMLFCoil.value = Checked
    Else
        IRMHFMode = False
        chkIRMHFCoil.value = Unchecked
        chkIRMLFCoil.value = Checked
    End If
End Sub

Public Sub SetIRMBackFieldMode(enabling As Boolean)
    If Not EnableIRMBackfield Then enabling = False
    If enabling Then
        IRMBackfieldMode = True
        chkBackfield.value = Checked
    Else
        IRMBackfieldMode = False
        chkBackfield.value = Unchecked
    End If
End Sub

Public Sub SetAutosetIRMEnabled(enabling As Boolean)
    If enabling Then
        AutosetIRMEnabled = True
        chkForceIRMCoil = Unchecked
    Else
        AutosetIRMEnabled = False
        chkForceIRMCoil = Checked
    End If
End Sub

Public Sub AutosetIRMHFMode(field As Double)
    If Not AutosetIRMEnabled Then Exit Sub
    If Not EnableIRMHi Then
        SetIRMHFMode 0
    ElseIf IRMBackfieldMode And EnableIRMBackfield Then
        SetIRMHFMode 0
    ElseIf Abs(field) > PulseLFMax Then
        SetIRMHFMode 1
    Else
        SetIRMHFMode 0
    End If
End Sub

Public Function FireIRMAtField(ByVal Gauss As Double) As Double
    Dim PulseVoltsOut As Double
    Dim MCCVoltsOut As Double
    If Gauss < 0 And EnableIRMBackfield Then
        SetIRMBackFieldMode True
        Gauss = -Gauss
    Else
        SetIRMBackFieldMode False
    End If
    AutosetIRMHFMode Gauss
    PulseVoltsOut = ConvertGaussToPulseVolts(Gauss)
    MCCVoltsOut = ConvertPulseVoltsToMCCVolts(PulseVoltsOut)
    txtPulseVolts = PulseVoltsOut
    If MCCVoltsOut < 0 Then
        MCCVoltsOut = 0
    ElseIf MCCVoltsOut > 10 Then
        MCCVoltsOut = 10
    End If
    FireIRM PulseVoltsOut
    FireIRMAtField = ConvertMCCVoltsToPulseVolts(MCCVoltsOut)
    ' return true field
End Function

Public Sub FireIRM(voltage As Double)
    Dim i As Integer
    Dim readySignals As Integer
    Dim readvoltage As Double
    Dim targetVoltage As Double
    Dim sensitivity As Double
    If Not EnableIRM Then Exit Sub
    If DEBUG_MODE Then frmDebug.Msg "Fire IRM at " & voltage & " V"
    IRMInterrupt = False
    targetVoltage = voltage
    voltage = ConvertPulseVoltsToMCCVolts(voltage)
    If voltage < 0 Then voltage = 0
    If voltage > PulseVoltMax Then voltage = PulseVoltMax
    txtPulseVolts = Format$(ConvertMCCVoltsToPulseVolts(voltage), "0.0")
    txtPulseField = Format$(ConvertPulseVoltsToGauss(ConvertMCCVoltsToPulseVolts(voltage)), "0.0")
    If voltage = 0 Then SetIRMHFMode 0
    frmAF.Connect
    If IRMBackfieldMode Then
        frmAF.ConfigureCoil IRMLFBackfieldAxis
    ElseIf IRMHFMode = 1 Then
        frmAF.ConfigureCoil IRMHFAxis
    Else
        frmAF.ConfigureCoil IRMLFAxis
    End If
    ' clear voltage
    frmMCC.AnalogOutput IRMVoltageOut, 0
    txtMCCIRMVout = "0"
    DelayTime 0.05
    frmMCC.AnalogOutput IRMVoltageOut, voltage
    txtMCCIRMVout = Str$(voltage)
    DelayTime 0.1
    frmMCC.DigitalOutput IRMTrim, 0
    txtMCCIRMTrim = "0"
    If targetVoltage > 0 Then
        lblIRMStatus.Caption = "Charging"
        If EnableIRMReturn Then
            ' wait for the capacitor voltage to be within 1% of target
            ' get at least three reads
            sensitivity = 0.5 / targetVoltage
            If sensitivity < 0.01 Then sensitivity = 0.01
            readySignals = 0
            DelayTime 2
            Do While readySignals < 3 And targetVoltage > 0 And Not IRMInterrupt
                readvoltage = IRMAverageVoltageIn
                lblIRMStatus.Caption = "Charging: " & Format$(100 * (readvoltage / targetVoltage), "##0.0") & "%"
                If Abs((readvoltage / targetVoltage) - 1) < sensitivity Then
                    readySignals = readySignals + 1
                    frmMCC.AnalogOutput IRMVoltageOut, 0
                    txtMCCIRMVout = "0"
                    DelayTime 0.3
                ElseIf readvoltage > targetVoltage Then
                    readySignals = readySignals - 1
                    If readySignals < 0 Then IRMBleedBelowVoltage targetVoltage
                ElseIf readvoltage < targetVoltage Then
                    readySignals = 0
                    frmMCC.AnalogOutput IRMVoltageOut, voltage
                    txtMCCIRMVout = Str$(voltage)
                End If
                DelayTime 0.05
            Loop
            If IRMInterrupt Then
                IRMInterrupt = False
                lblIRMStatus.Caption = "Charge Interrupted"
                Exit Sub
            End If
        Else
            lblIRMStatus.Caption = "Charging"
            DelayTime 2
            For i = 1 To 3
                Do While Not (IRMIsReady = 0 Or NOCOMM_MODE Or IRMInterrupt)
                    lblIRMStatus.Caption = "Charging"
                    DelayTime 0.3
                Loop
                If IRMInterrupt Then
                    IRMInterrupt = False
                    lblIRMStatus.Caption = "Charge Interrupted"
                    Exit Sub
                End If
                If (IRMIsReady = 0 Or NOCOMM_MODE) Then lblIRMStatus.Caption = "Ready Signal " & Str$(i) Else i = 0
                DelayTime 0.3
            Next i

        End If
    End If
    ' fire IRM
    DelayTime 1
    lblIRMStatus.Caption = "Firing"
    frmMCC.DigitalOutput IRMFire, 0
    txtMCCIRMFire = "0"
    DelayTime 1
    frmMCC.DigitalOutput IRMFire, 1
    txtMCCIRMFire = "1"
    lblIRMStatus.Caption = vbNullString
    ' return to normal status
    frmMCC.AnalogOutput IRMVoltageOut, 0
    txtMCCIRMVout = "0"
End Sub

Public Function IRMIsReady() As Integer
    IRMIsReady = frmMCC.DigitalInput(IRMReady)
    txtMCCIRMReady = Str$(IRMIsReady)
End Function

Public Sub IRMBleedBelowVoltage(voltage As Double)
    Dim readySignals As Integer
    Dim readvoltage As Double
    If Not EnableIRMReturn Then Exit Sub
    If voltage < 0.1 Then Exit Sub
    readvoltage = IRMAverageVoltageIn
    If readvoltage < voltage Then Exit Sub
    frmMCC.AnalogOutput IRMVoltageOut, 0
    txtMCCIRMVout = "0"
    frmMCC.DigitalOutput IRMTrim, 1
    txtMCCIRMTrim = "1"
    Do While readySignals < 3
        readvoltage = IRMAverageVoltageIn
        lblIRMStatus.Caption = "Trimming: " & Format$(100 * (readvoltage / voltage), "##0.0") & "%"
        If readvoltage < voltage Then readySignals = readySignals + 1
        DelayTime 0.02
    Loop
    frmMCC.DigitalOutput IRMTrim, 0
    txtMCCIRMTrim = "0"
    lblIRMStatus.Caption = vbNullString
End Sub

Public Function IRMCapacitorVoltage() As Double
    IRMCapacitorVoltage = frmMCC.AnalogInput(IRMCapacitorVoltageIn)
    txtMCCIRMVin = IRMCapacitorVoltage
End Function

Public Sub SetBiasField(ByVal Gauss As Double)
    Dim i As Integer
    Dim voltage As Double
    If Not EnableARM Then Exit Sub
    If DEBUG_MODE Then frmDebug.Msg "Set bias field " & Str$(Gauss) & " G"
    CurrentBiasField = Gauss
    voltage = ARMVoltGauss * Gauss
    If voltage < 0 Then voltage = 0
    If voltage > ARMVoltMax Then voltage = ARMVoltMax
    txtBiasField = voltage / ARMVoltGauss
    frmMCC.AnalogOutput ARMVoltageOut, 0
    txtMCCARMVout = "0"
    DelayTime 0.5
    If Gauss > 0 Then
        frmMCC.DigitalOutput ARMSet, 0
        txtMCCARMSet = "0"
        DelayTime 0.5
        frmMCC.AnalogOutput ARMVoltageOut, voltage
        txtMCCARMVout = Str$(voltage)
        ARMStartTime = Now
    Else
        frmMCC.AnalogOutput ARMVoltageOut, 0
        txtMCCARMVout = "0"
        DelayTime 0.5
        frmMCC.DigitalOutput ARMSet, 1
        txtMCCARMSet = "1"
    End If
End Sub

Private Function ConvertPulseVoltsToGauss(VOLTS As Double)
    If IRMHFMode Then
        ConvertPulseVoltsToGauss = ConvertPulseHFVoltsToGauss(VOLTS)
    Else
        ConvertPulseVoltsToGauss = ConvertPulseLFVoltsToGauss(VOLTS)
    End If
End Function

Private Function ConvertGaussToPulseVolts(field As Double) As Double
    If field < 0 Then field = -field
    If IRMHFMode Then
        ConvertGaussToPulseVolts = ConvertGaussToPulseHFVolts(field)
    Else
        ConvertGaussToPulseVolts = ConvertGaussToPulseLFVolts(field)
    End If
End Function

Private Function ConvertPulseLFVoltsToGauss(VOLTS As Double)
    Dim i As Integer
    Dim slope As Double
    'ConvertPulseLFVoltsToGauss = PulseLFY + PulseLFSlope * VOLTS
    ConvertPulseLFVoltsToGauss = 0
    For i = 1 To 20
        If PulseLFX(i) = VOLTS Then
            ConvertPulseLFVoltsToGauss = PulseLFY(i)
            Exit Function
        ElseIf PulseLFX(i - 1) < VOLTS And PulseLFX(i) > VOLTS Then
            slope = (PulseLFY(i) - PulseLFY(i - 1)) / (PulseLFX(i) - PulseLFX(i - 1))
            ConvertPulseLFVoltsToGauss = PulseLFY(i - 1) + slope * (VOLTS - PulseLFX(i - 1))
            Exit For
        End If
    Next i
End Function

Private Function ConvertGaussToPulseLFVolts(field As Double) As Double
    Dim i As Integer
    Dim slope As Double
    If field < 0 Then field = -field
    If field < PulseLFMin Then field = PulseLFMin
    If field > PulseLFMax Then field = PulseLFMax
    ConvertGaussToPulseLFVolts = -1
    For i = 1 To 20
            If PulseLFY(i) = field Then
                ConvertGaussToPulseLFVolts = PulseLFX(i)
                Exit Function
            ElseIf PulseLFY(i - 1) < field And PulseLFY(i) > field Then
                slope = (PulseLFX(i) - PulseLFX(i - 1)) / (PulseLFY(i) - PulseLFY(i - 1))
                ConvertGaussToPulseLFVolts = PulseLFX(i - 1) + slope * (field - PulseLFY(i - 1))
                Exit For
            End If
    Next i
    'ConvertGaussToPulseLFVolts = (field - PulseLFY) / PulseLFSlope
End Function

Private Function ConvertPulseHFVoltsToGauss(VOLTS As Double)
    'ConvertPulseHFVoltsToGauss = PulseHFY + PulseHFSlope * VOLTS
    Dim i As Integer
    Dim slope As Double
    ConvertPulseHFVoltsToGauss = 0
    For i = 1 To 20
        If PulseHFX(i) = VOLTS Then
            ConvertPulseHFVoltsToGauss = PulseHFY(i)
            Exit Function
        ElseIf PulseHFX(i - 1) < VOLTS And PulseHFX(i) > VOLTS Then
            slope = (PulseHFY(i) - PulseHFY(i - 1)) / (PulseHFX(i) - PulseHFX(i - 1))
            ConvertPulseHFVoltsToGauss = PulseHFY(i - 1) + slope * (VOLTS - PulseHFX(i - 1))
            Exit For
        End If
    Next i
End Function

Private Function ConvertGaussToPulseHFVolts(field As Double) As Double
    Dim i As Integer
    Dim slope As Double
    If field < 0 Then field = -field
    If field < PulseHFMin Then field = PulseHFMin
    If field > PulseHFMax Then field = PulseHFMax
    ConvertGaussToPulseHFVolts = -1
    For i = 1 To 20
            If PulseHFY(i) = field Then
                ConvertGaussToPulseHFVolts = PulseHFX(i)
                Exit Function
            ElseIf PulseHFY(i - 1) < field And PulseHFY(i) > field Then
                slope = (PulseHFX(i) - PulseHFX(i - 1)) / (PulseHFY(i) - PulseHFY(i - 1))
                ConvertGaussToPulseHFVolts = PulseHFX(i - 1) + slope * (field - PulseHFY(i - 1))
                Exit For
            End If
    Next i
    'ConvertGaussToPulseHFVolts = (field - PulseHFY) / PulseHFSlope
End Function

Private Function ConvertPulseVoltsToMCCVolts(VOLTS As Double) As Double
        ConvertPulseVoltsToMCCVolts = VOLTS * PulseMCCVoltConversion
End Function

Private Function ConvertMCCVoltsToPulseVolts(VOLTS As Double) As Double
    ConvertMCCVoltsToPulseVolts = VOLTS / PulseMCCVoltConversion
End Function

Private Sub chkBackfield_Click()
    IRMBackfieldMode = chkBackfield.value
End Sub

Private Sub cmdInterruptCharge_Click()
    IRMInterruptCharge
End Sub

Private Sub cmdIRMAverageVoltageIn_Click()
    IRMAverageVoltageIn
End Sub

Private Sub cmdMCCARMSet_Click()
    frmMCC.DigitalOutput ARMSet, val(txtMCCARMSet)
End Sub

Private Sub cmdMCCARMVout_Click()
    frmMCC.AnalogOutput ARMVoltageOut, val(txtMCCARMVout)
End Sub

Private Sub cmdMCCIRMFire_Click()
    frmMCC.DigitalOutput IRMFire, val(txtMCCIRMFire)
End Sub

Private Sub cmdMCCIRMReady_Click()
    txtMCCIRMReady = Str$(frmMCC.DigitalInput(IRMReady))
End Sub

Private Sub cmdMCCIRMTrim_Click()
    frmMCC.DigitalOutput IRMTrim, val(txtMCCIRMTrim)
End Sub

Private Sub cmdMCCIRMVin_Click()
    txtMCCIRMVin = Str$(frmMCC.AnalogInput(IRMCapacitorVoltageIn))
End Sub

Private Sub cmdMCCIRMVout_Click()
    frmMCC.AnalogOutput IRMVoltageOut, val(txtMCCIRMVout)
End Sub

Public Function IRMAverageVoltageIn(Optional ByVal times As Integer = 200) As Double
    Dim i As Integer
    Dim sum As Double
    Dim working As Double
    For i = 1 To times
        working = IRMCapacitorVoltage
        sum = sum + working
        txtMCCIRMVin = Str$(working)
    Next i
    IRMAverageVoltageIn = sum / times / PulseReturnMCCVoltConversion
    txtIRMAverageVoltageIn = IRMAverageVoltageIn
End Function

Public Sub Form_Load()
    Load frmMCC
    frmMCC.AnalogOutput ARMVoltageOut, 0
    txtMCCARMVout = "0"
    frmMCC.AnalogOutput IRMVoltageOut, 0
    txtMCCIRMVout = "0"
    frmMCC.DigitalOutput IRMTrim, 0
    txtMCCIRMTrim = "0"
    frmMCC.DigitalOutput IRMFire, 1
    txtMCCIRMFire = "1"
    DelayTime 0.5
    frmMCC.DigitalOutput ARMSet, 1
    txtMCCARMSet = "1"
    SetAutosetIRMEnabled True
    SetIRMHFMode False
    SetIRMBackFieldMode False
End Sub

Private Sub tmrARMWatch_Timer()
    ' Check and see if Bias field has been on too long
    If ((Now - ARMStartTime) > ARMTimeMax) And (CurrentBiasField > 0) Then
        SetBiasField 0
    End If
End Sub

Private Sub cmdClose_Click()
    Me.Hide
End Sub

Private Sub cmdShowMCC_Click()
    frmMCC.ZOrder
    frmMCC.Show
End Sub

Private Sub cmdIRMFirebyGauss_Click()
    FireIRMAtField (val(txtPulseField))
End Sub

Private Sub cmdSetBiasField_Click()
    SetBiasField val(txtBiasField)
End Sub

Private Sub chkForceIRMCoil_Click()
    If chkForceIRMCoil.value = Checked Then
        SetAutosetIRMEnabled False
    Else
        SetAutosetIRMEnabled True
    End If
End Sub

Private Sub SetHFModeFromForm()
    If chkIRMHFCoil.value = Checked Then
        If chkIRMLFCoil.value = Checked Then SetIRMHFMode 2 Else SetIRMHFMode 1
    Else
        If chkIRMLFCoil.value = Unchecked Then chkIRMLFCoil.value = Checked
        SetIRMHFMode 0
    End If
End Sub

Private Sub chkIRMHFCoil_Click()
    SetHFModeFromForm
End Sub

Private Sub chkIRMLFCoil_Click()
    SetHFModeFromForm
End Sub

Private Sub form_resize()
    Me.Height = 4200
    Me.Width = 7365
End Sub

Private Sub cmdIRMFire_Click()
    FireIRM val(txtPulseVolts)
End Sub
